/*
 * QrfeTraceModel.h
 *
 *  Created on: 15.02.2011
 *      Author: stefan.detter
 */

#ifndef QRFETRACEMODEL_H_
#define QRFETRACEMODEL_H_

#include <QObject>
#include <QColor>
#include <QMap>

class QAbstractItemView;
class QStandardItemModel;
class QSortFilterProxyModel;

class QrfeTraceModel : public QObject
{
	Q_OBJECT

public:
	QrfeTraceModel(QObject* parent = 0);
	~QrfeTraceModel();

	void setView(QAbstractItemView* view);
	void setSeperator( QChar sep );
	void setEnabled ( bool enabled );

public slots:
	void trace( const QString& message);
	void clear();
	void exportTrace();

private:
	void setHeader();

private:
	QStandardItemModel* 	m_model;
	QAbstractItemView* 		m_view;
	QSortFilterProxyModel* 	m_proxy;

	bool 					m_enabled;
	QChar 					m_seperator;

	QMap<QString, QColor> 	m_threadColors;
};

#endif /* QRFETRACEMODEL_H_ */
